;----------------------------------------------------------------------------
; Pop Cap
; PCLauncher.exe
; by djvj
; 1.0
;
; Info:
; Blank txt files need to be created for every game
; settings.ini needs to reside with the blank txt files and contain an entry for each game, pointing to the OpenBOR.exe
; example:
;
; [Alchemy Deluxe]
; gamePath = Alchemy Deluxe\Alchemy Deluxe.exe
; [Bejeweled 3]
; gamePath = Bejeweled 3\Bejeweled3.exe
;
; emuPath and exe need to point to a dummy exe, like PCLauncher.exe
; romPath needs to point to the dir with all the blank txt files and the settings.ini
; Exit the games via their main menus, escape is needed for in-game menu usage.
;----------------------------------------------------------------------------

IniRead, gamePath, %rompath%settings.ini, %romName%, gamePath

Run, "%romPath%%gamePath%", %romPath%%romName%,, game_PID
GoSub, RemoveWinKeys
Process, Priority, %game_PID%, High

;These conditionals are here to resolve win7 compatibility issues with these games (their exes don't close when you exit the game)
If romName = Super Collapse 3
{
	Sleep, 3000
	WinWaitNotActive, Super Collapse! 3
	Process, close, SuperCollapseIII.exe
}
Else If romName = Typer Shark Deluxe
{
	Sleep, 3000
	WinWaitNotActive, Typer Shark Deluxe 1.02
	Process, close, TyperShark.exe
}
Else
{
	Process, WaitClose, %game_PID%
}

WinActivate, HyperSpin

ExitApp

;This remaps windows Start keys to Return to prevent accidental leaving of game
RemoveWinKeys:
RWin::return
LWin::return
return

CloseProcess:
return